implementation module osevent

import	clCrossCall
import	ostoolbox
from	commondef	import HdTl
//import	trace, tracetypes

/* PA: The following functions and OSEvent type are not used anymore.
// RWS +++ cyclic array event buffer for efficiency
:: *OSEvents :== [OSEvent]

AddEvent :: OSEvent OSEvents -> OSEvents
AddEvent event events
	=	events ++ [event]

IsEmptyEvents :: OSEvents -> (Bool, OSEvents)
IsEmptyEvents []
	=	(True, [])
IsEmptyEvents events
	=	(False, events)

RemoveEvent :: OSEvents -> (OSEvent, OSEvents)
RemoveEvent [event : events]
	=	(event, events)
RemoveEvent []
	=	abort "RemoveEvent: event buffer underflow\n"
*/
::	*OSEvents		// A simpler type is now possible because nothing special happens with OSEvents
	:==	Int

OSNewEvents :: OSEvents
//	OSNewEvents = []
OSNewEvents = 0		// A simpler implementation is now possible because nothing special happens with OSEvents


::	OSEvent
	:==	CrossCallInfo
::	OSSleepTime		// The max time the process allows multi-tasking
	:== Int

OSNullEvent :: OSEvent
OSNullEvent
	=	{	ccMsg	= CcWmIDLETIMER
		,	p1		= 0
		,	p2		= 0
		,	p3		= 0
		,	p4		= 0
		,	p5		= 0
		,	p6		= 0
		}

// OSLongSleep :: OSSleepTime
OSLongSleep	:== 2^15-1
// OSNoSleep :: OSSleepTime
OSNoSleep	:== 0

OShandleEvents :: !(.s -> (Bool,.s)) !(.s -> (Int,.s)) !(OSEvent -> .s -> ([Int],.s)) !(!.s,!*OSToolbox) -> (!.s,!*OSToolbox)
OShandleEvents isFinalState getSleepTime handleOSEvent (state,tb)
	# (terminate,state)	= isFinalState state
	| terminate
	= (state,tb)
	# (sleep,state)		= getSleepTime state
	  getEventCci		= {ccMsg=CcRqDOMESSAGE,p1=toInt (sleep<>OSLongSleep),p2=0,p3=0,p4=0,p5=0,p6=0}
	# (_,state,tb)		= IssueCleanRequest (rccitoevent handleOSEvent) getEventCci state tb
	= OShandleEvents isFinalState getSleepTime handleOSEvent (state,tb)
where
	rccitoevent :: !(OSEvent -> .s -> ([Int],.s)) !CrossCallInfo !.s !*OSToolbox -> (!CrossCallInfo,!.s,!*OSToolbox)
	rccitoevent handleOSEvent cci=:{ccMsg} state tb
//		# (reply,state)	= handleOSEvent (if (ccMsg==CcWmIDLETIMER) cci (trace ("CcRqDOMESSAGE-->"+++toString cci) cci)) state
		# (reply,state)	= handleOSEvent cci state
		= (replytocrosscallinfo reply,state,tb)
	
	replytocrosscallinfo :: ![Int] -> CrossCallInfo
	replytocrosscallinfo reply
		# nrReply		= length reply
		| nrReply==0	= Return0Cci
		# (e1,reply)	= HdTl reply
		| nrReply==1	= Return1Cci e1
		# (e2,reply)	= HdTl reply
		| nrReply==2	= Return2Cci e1 e2
		# (e3,reply)	= HdTl reply
		| nrReply==3	= Return3Cci e1 e2 e3
		# (e4,reply)	= HdTl reply
		| nrReply==4	= Return4Cci e1 e2 e3 e4
		# (e5,reply)	= HdTl reply
		| nrReply==5	= Return5Cci e1 e2 e3 e4 e5
		# (e6,_)		= HdTl reply
		| nrReply==6	= Return6Cci e1 e2 e3 e4 e5 e6
		// otherwise	= abort "Fatal error in module osevent: number of reply codes > 6"


OSEventIsUrgent :: !OSEvent -> Bool
OSEventIsUrgent {ccMsg}
	= case ccMsg of
		CcWmACTIVATE		-> True
		CcWmBUTTONCLICKED	-> True
		CcWmCLOSE			-> True
		CcWmCOMBOSELECT		-> True
		CcWmCOMMAND			-> True
		CcWmDEACTIVATE		-> True
		CcWmDRAWCONTROL		-> True
		CcWmDRAWCLIPBOARD	-> False	// PA: in a future version, use this event to evaluate a clipboard callback function.
		CcWmGETMINMAXINFO	-> False
		CcWmIDLETIMER		-> False
		CcWmKEYBOARD		-> True
		CcWmLOSEMODELESSDLOG-> True
		CcWmMOUSE			-> True
		CcWmPAINT			-> True
		CcWmSCROLLBARACTION	-> True
		CcWmSETCURSOR		-> False
		CcWmSIZE			-> True
		CcWmTIMER			-> False
		msg					-> abort ("Fatal error in module osevent: unknown message type: "+++toString msg)//False

/*	used by trace in rccitoevent.
instance toString CrossCallInfo where
	toString {ccMsg,p1,p2,p3,p4,p5,p6}
		= toString (ccMsgString ccMsg,p1,p2,p3,p4,p5,p6)
	where
		ccMsgString CcWmACTIVATE		= "CcWmACTIVATE"
		ccMsgString CcWmBUTTONCLICKED	= "CcWmBUTTONCLICKED"
		ccMsgString CcWmCLOSE			= "CcWmCLOSE"
		ccMsgString CcWmCOMBOSELECT		= "CcWmCOMBOSELECT"
		ccMsgString CcWmCOMMAND			= "CcWmCOMMAND"
		ccMsgString CcWmDEACTIVATE		= "CcWmDEACTIVATE"
		ccMsgString CcWmDRAWCLIPBOARD	= "CcWmDRAWCLIPBOARD"
		ccMsgString CcWmDRAWCONTROL		= "CcWmDRAWCONTROL"
		ccMsgString CcWmGETMINMAXINFO	= "CcWmGETMINMAXINFO"
		ccMsgString CcWmIDLETIMER		= "CcWmIDLETIMER"
		ccMsgString CcWmKEYBOARD		= "CcWmKEYBOARD"
		ccMsgString CcWmLOSEMODELESSDLOG= "CcWmLOSEMODELESSDLOG"
		ccMsgString CcWmMOUSE			= "CcWmMOUSE"
		ccMsgString CcWmPAINT			= "CcWmPAINT"
		ccMsgString CcWmSCROLLBARACTION	= "CcWmSCROLLBARACTION"
		ccMsgString CcWmSETCURSOR		= "CcWmSETCURSOR"
		ccMsgString CcWmSIZE			= "CcWmSIZE"
		ccMsgString CcWmTIMER			= "CcWmTIMER"
		ccMsgString msg					= "(Other message: "+++toString msg+++")"
*/
